package cn.com.duiba.quanyi.center.api.remoteservice.api;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.api.ApiJointConfigExtDto;

import java.util.List;
import java.util.Map;

/**
 * API供给配置扩展表
 * @author kjj mybatis generator 
 * @date 2024-07-03
 */
@AdvancedFeignClient
public interface RemoteApiJointConfigExtService {

    /**
     * 根据对接配置Id查询
     * @param apiJointId 对接配置Id
     * @return API供给配置扩展
     */
    List<ApiJointConfigExtDto> selectByApiJointId(Long apiJointId);

    /**
     * 根据对接配置Id查询
     * @param apiJointId 对接配置Id
     * @return key:confName, value:confValue
     */
    Map<Integer, String> selectMapByApiJointId(Long apiJointId);

    /**
     * 根据对接配置Id批量查询
     * @param apiJointIds 对接配置Id
     * @return key:confName, value:confValue
     */
    Map<Long, Map<Integer, String>> selectMapByApiJointIds(List<Long> apiJointIds);

    /**
     * 根据唯一约束查询
     *
     * @param apiJointId 对接配置ID
     * @param confName   扩展配置key
     * @return API供给配置扩展
     */
    ApiJointConfigExtDto selectByUkWithLocal(Long apiJointId, Integer confName);

    /**
     * 新增
     *
     * @param dto dto
     * @return 执行结果
     */
    int insert(ApiJointConfigExtDto dto);

    /**
     * 更新
     *
     * @param dto dto
     * @return 影响行数
     */
    int update(ApiJointConfigExtDto dto);

    /**
     * 物理删除
     *
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

}