package cn.com.duiba.quanyi.center.api.enums.template;

import lombok.AllArgsConstructor;
import lombok.Getter;


/**
 * 字段类型
 *
 * @author wangguanhua
 */
@Getter
@AllArgsConstructor
public enum TemplateFieldTypeEnum {

    STRING("string", "字符串类型"),
    NUMBER("number", "数值类型"),
    BOOLEAN("boolean", "布尔类型"),
    OBJECT("object", "对象类型"),
    ARRAY("array", "数组类型"),
    ;
    /**
     * 类型
     */
    private final String type;

    /**
     * 描述
     */
    private final String desc;

    public static TemplateFieldTypeEnum getFieldTypeEnum(String type) {
        for (TemplateFieldTypeEnum fieldType : TemplateFieldTypeEnum.values()) {
            if (fieldType.getType().equals(type)) {
                return fieldType;
            }
        }
        return null;
    }

}
