package cn.com.duiba.quanyi.center.api.dto.qystatistic;

import cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 运营工作台-消耗数据统计表
 * @author mybatis generator
 * @date 2025-06-05
 */
@Data
public class ConsumeStatisticDto implements Serializable {

    private static final long serialVersionUID = 17491225401655226L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 1：活动id字符串，2.奖品id字符串以此类推
     */
    private String statId;

    /**
     * 名称
     */
    private String statName;

    /**
     * 统计类型
     * @see cn.com.duiba.quanyi.center.api.enums.statistic.ConsumeStatisitcTypeEnum
     */
    private Integer statType;

    /**
     * 消耗数
     */
    private Long consumedNum;

    /**
     * 环比近3日均值百分比
     */
    private String chainPercentage;

    /**
     * 环比近3日均值百分比：1：上涨 2：下跌
     */
    private Integer chainType;

    /**
     * 对应活动、奖品、需求...创建人id
     */
    private Long createOperatorId;

    /**
     * 处理状态 0=待处理，1=已处理
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer processStatus;

    /**
     * stat_type为2,4时有值，对应活动id，需求id
     */
    private String parentStatId;

    /**
     * 是否异常 0=正常，1=异常
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer abnormalFlag;

    /**
     * 异常类型 1=涨幅超+20%，2=跌幅超-20%
     */
    private Integer abnormalType;

    /**
     * 活动类型
     * @see BizActTypeEnum
     */
    private Integer activityType;

    /**
     * 统计日期
     */
    private Date statDate;
}
