package cn.com.duiba.quanyi.center.api.remoteservice.settlement.receive;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.settlement.receive.ReceivedPaymentRecordDto;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 回款关联或取消关联记录
 * @author kjj mybatis generator
 * @date 2024-12-11
 */
@AdvancedFeignClient
public interface RemoteReceivedPaymentRecordService {

    /**
     * 查询回款最后一次记录
     * @param receiveId 回款ID
     * @return 回款关联或取消关联记录
     */
    ReceivedPaymentRecordDto selectLastByReceiveId(Long receiveId);

    /**
     * 批量查询回款最后一次记录Id
     * @param receiveIds 回款ID
     * @return key：回款ID，value：回款最后一次记录Id
     */
    Map<Long, Long> selectMaxIdMapByReceiveIds(Set<Long> receiveIds);

    /**
     * 批量查询回款指定审批状态的记录
     * @param receiveIds 回款ID
     * @param approvalStatusList 审批状态
     * @return 回款关联或取消关联记录
     */
    List<ReceivedPaymentRecordDto> selectByReceiveIdsAndApprovalStatus(List<Long> receiveIds, List<Integer> approvalStatusList);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 回款关联或取消关联记录
     */
    ReceivedPaymentRecordDto selectById(Long id);
}
