package cn.com.duiba.quanyi.center.api.remoteservice.payment;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.BaseResultDto;
import cn.com.duiba.quanyi.center.api.dto.payment.PaymentInfoPrepaymentDto;
import cn.com.duiba.quanyi.center.api.param.payment.PaymentInfoPrepaymentSaveParam;
import cn.com.duiba.quanyi.center.api.param.payment.PaymentInfoPrepaymentSearchParam;
import java.util.List;
import java.util.Set;

/**
 * 打款申请-预付款退款
 * @author kjj mybatis generator
 * @date 2025-08-28
 */
@AdvancedFeignClient
public interface RemotePaymentInfoPrepaymentService {

    /**
     * 根据条件查询所有的付款ID
     * @param param 查询条件
     * @return 打款申请-预付款退款集合
     */
    List<Long> selectPaymentIdList(PaymentInfoPrepaymentSearchParam param);

    /**
     * 根据预付款ID查询
     * @param settlementId 预付款ID
     * @return 打款申请-预付款退款
     */
    List<PaymentInfoPrepaymentDto> selectBySettlementId(Long settlementId);

    /**
     * 根据付款ID查询
     * @param paymentId 付款ID
     * @return 打款申请-预付款退款
     */
    PaymentInfoPrepaymentDto selectByPaymentId(Long paymentId);

    /**
     * 根据付款ID查询
     * @param paymentIds 付款ID
     * @return 打款申请-预付款退款
     */
    List<PaymentInfoPrepaymentDto> selectListByPaymentIds(Set<Long> paymentIds);

    /**
     * 保存开票申请
     * @param param 保存参数
     * @return 主键
     */
    BaseResultDto<Long> save(PaymentInfoPrepaymentSaveParam param);

    /**
     * 删除付款申请
     * @param id 主键
     * @return 主键
     */
    BaseResultDto<Boolean> delete(Long id);
}
