package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 多选N维度枚举
 * @author yangyukang
 * @date 2025-01-20
 */
@Getter
@AllArgsConstructor
public enum MultiSelectNDimensionEnum {

    /**
     * 永久（不限制和永久合并，统一使用0表示永久）
     */
    PERMANENT(0, "永久"),

    /**
     * 日
     */
    DAY(1, "日"),

    /**
     * 自然周
     */
    WEEK(2, "自然周"),

    /**
     * 自然月
     */
    MONTH(3, "自然月"),

    /**
     * 自然季度
     */
    QUARTER(4, "自然季度"),

    /**
     * 自定义
     */
    CUSTOM(5, "自定义"),
    ;

    private final Integer code;

    private final String desc;

    /**
     * 根据code获取枚举
     * @param code 编码
     * @return 枚举
     */
    public static MultiSelectNDimensionEnum getByCode(Integer code) {
        if (code == null) {
            return PERMANENT; // 不限制和永久合并，统一使用0表示永久
        }
        for (MultiSelectNDimensionEnum dimensionEnum : values()) {
            if (dimensionEnum.getCode().equals(code)) {
                return dimensionEnum;
            }
        }
        return PERMANENT; // 不限制和永久合并，统一使用0表示永久
    }
}
