package cn.com.duiba.quanyi.center.api.enums.contract;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 结算类型枚举
 */
@Getter
@AllArgsConstructor
public enum SettlementTypeEnum {
    
    MONTHLY(1, "月结"),
    
    QUARTERLY(2, "季结"),
    
    BI_MONTHLY(3, "双月结算"),
    
    PREPAYMENT(4, "预付款");
    
    private final Integer type;
    
    private final String desc;
    
    public static SettlementTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        for (SettlementTypeEnum e : SettlementTypeEnum.values()) {
            if (e.getType().equals(type)) {
                return e;
            }
        }
        return null;
    }
    
    public static String getDescByType(Integer type) {
        SettlementTypeEnum e = getByType(type);
        return e != null ? e.getDesc() : null;
    }
}
