package cn.com.duiba.quanyi.center.api.enums.questionnaire;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhi
 * @date 2025/10/28 19:58
 */
@AllArgsConstructor
@Getter
public enum QuestionnaireQuestionTypeEnum {
    SINGLE_CHOICE(1, "单选"),
    MULTIPLE_CHOICE(2, "多选"),
    TEXT(3, "文本"),
    ;
    private final Integer type;
    private final String desc;

    public static boolean isChoice(Integer type) {
        return SINGLE_CHOICE.getType().equals(type) || MULTIPLE_CHOICE.getType().equals(type);
    }
}
