package cn.com.duiba.quanyi.center.api.remoteservice.dayan;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.dayan.demand.DayanDemandGoodsDto;
import cn.com.duiba.quanyi.center.api.dto.dayan.demand.DayanDemandNameDto;
import cn.com.duiba.quanyi.center.api.param.dayan.demand.DayanDemandGoodsListParam;
import cn.com.duiba.quanyi.center.api.param.dayan.demand.DayanDemandNameListParam;

import java.util.List;

/**
 * @author xuzhigang
 * @date 2025/11/5 11:42
 **/
@AdvancedFeignClient
public interface RemoteDayanDemandService {

    /**
     * 大雁需求名称列表
     *
     * @param param 查询参数
     * @return 大雁需求名称列表
     */
    List<DayanDemandNameDto> demandNameList(DayanDemandNameListParam param);

    /**
     * 大雁卡密需求商品列表
     *
     * @param param 查询参数
     * @return 大雁需求商品列表
     */
    List<DayanDemandGoodsDto> cardDemandGoodsList(DayanDemandGoodsListParam param);
}
