package cn.com.duiba.quanyi.center.api.enums.contract;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 预付方式枚举
 */
@Getter
@AllArgsConstructor
public enum PrepaymentMethodEnum {

    PLAN_30_50_20("30%_50%_20%",  3),
    PLAN_30_30_40("30%_30%_40%", 3),
    PLAN_30_40_30("30%_40%_30%", 3),
    PLAN_20_40_40("20%_40%_40%", 3),
    PLAN_40_40_20("40%_40%_20%",  3),
    PLAN_15_60_25("15%_60%_25%",  3),
    PLAN_50_30_20("50%_30%_20%",  3),
    PLAN_50_20_30("50%_20%_30%",  3),

    PLAN_80_20("80%_20%",  2),
    PLAN_20_80("20%_80%", 2),
    PLAN_70_30("70%_30%",  2),
    PLAN_30_70("30%_70%", 2);

    private final String code;

    private final Integer paymentTimes;

    public static PrepaymentMethodEnum getByCode(String code) {
        if (code == null || code.isEmpty()) {
            return null;
        }
        for (PrepaymentMethodEnum e : PrepaymentMethodEnum.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return null;
    }

    public static boolean isValid(String code) {
        return getByCode(code) != null;
    }

    public static PrepaymentMethodEnum[] getByPaymentTimes(Integer paymentTimes) {
        if (paymentTimes == null) {
            return values();
        }
        return java.util.Arrays.stream(values())
                .filter(e -> e.getPaymentTimes().equals(paymentTimes))
                .toArray(PrepaymentMethodEnum[]::new);
    }
}
