/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.activity.common;

import cn.com.duiba.wolf.utils.DateUtils;
import cn.hutool.core.date.DateUtil;
import java.util.Date;

public enum ActivityPaymentExpireEnum {
    ABSOLUTE(2, "\u7edd\u5bf9\u65f6\u95f4"),
    DAY(3, "\u5f53\u65e5"),
    WEEK(4, "\u5f53\u5468"),
    MONTH(5, "\u5f53\u6708"),
    DAYS_AFTER(7, "\u56fa\u5b9a\u5929\u6570");

    private final Integer code;
    private final String desc;

    public static ActivityPaymentExpireEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (ActivityPaymentExpireEnum e : ActivityPaymentExpireEnum.values()) {
            if (!e.getCode().equals(code)) continue;
            return e;
        }
        return null;
    }

    public static Date getDeadLineDateTime(Date payDateTime, Integer expireType, Date expireDateTime, Integer expireDays) {
        if (payDateTime == null) {
            return null;
        }
        ActivityPaymentExpireEnum expireTypeEnum = ActivityPaymentExpireEnum.getByCode(expireType);
        if (expireTypeEnum == null) {
            return null;
        }
        switch (expireTypeEnum) {
            case DAY: {
                return DateUtil.endOfDay((Date)payDateTime);
            }
            case WEEK: {
                return DateUtil.endOfWeek((Date)payDateTime);
            }
            case MONTH: {
                return DateUtil.endOfMonth((Date)payDateTime);
            }
            case DAYS_AFTER: {
                if (expireDays == null) {
                    return null;
                }
                return DateUtil.endOfDay((Date)DateUtils.daysAddOrSub((Date)payDateTime, (int)expireDays));
            }
            case ABSOLUTE: {
                if (expireDays == null) {
                    return null;
                }
                return DateUtil.endOfDay((Date)expireDateTime);
            }
        }
        return null;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    private ActivityPaymentExpireEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}

