package cn.com.duiba.quanyi.center.api.remoteservice.mall.cart;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.mall.cart.MallCartDto;

/**
 * 购物车主表
 *
 * @author zzy
 * @date 2025-12-03 20:39
 */
@AdvancedFeignClient
public interface RemoteMallCartService {

    /**
     * 新增
     *
     * @param dto 购物车
     * @return 主键ID
     */
    Long insert(MallCartDto dto);

    /**
     * 根据company_id、user_id、cart_type查询
     *
     * @param companyId 公司ID
     * @param userId    用户ID
     * @param cartType  购物车类型
     * @return 购物车
     */
    MallCartDto selectByCompanyIdAndUserIdAndCartType(Long companyId, Long userId, Integer cartType);

    /**
     * 根据id查询
     *
     * @param id 主键
     * @return 购物车
     */
    MallCartDto selectById(Long id);
}

