package cn.com.duiba.quanyi.center.api.param.settlement.holo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author lizhi
 * @date 2024/11/26 16:26
 */
@Data
public class SettlementHoloPreviewParam implements Serializable {

    private static final long serialVersionUID = 8716875783192392242L;

    /**
     * 项目ID
     */
    private Long projectId;

    /**
     * 对接人ID
     */
    private List<Long> contactsIdList;

    /**
     * 需求ID
     */
    private List<Long> demandIdList;

    /**
     * 结算周期-开始时间
     */
    private Date startDate;

    /**
     * 结算周期-结束时间
     */
    private Date endDate;

    /**
     * 选择的商品批次
     */
    private List<SettlementHoloGoodsSelectParam> selectList;

    /**
     * 期望金额
     */
    private Long expectedAmount;

    /**
     * lockStatus
     */
    private Integer lockStatus = 0;

    /**
     * 需求商品ID
     */
    private List<Long> demandGoodsIdList;

    /**
     * 用于分批查询,倒序排序，id > lastId
     */
    private Long lastId;

    /**
     * 任务ID
     */
    private String taskId;

    /**
     * 按核销商品ID
     */
    private List<Long> verifyDemandGoodsIdList;

    /**
     * 按订单交易成功商品ID
     */
    private List<Long> successDemandGoodsIdList;

    /**
     * 按签收商品ID
     */
    private List<Long> signDemandGoodsIdList;

    /**
     * 按打款商品ID
     */
    private List<Long> paymentDemandGoodsIdList;

    /**
     * 按发放商品ID
     */
    private List<Long> grantDemandGoodsIdList;

    /**
     * 统计日期
     */
    private Date statDate;

    /**
     * 统计日志ID
     */
    private Long statId;

    /**
     * 采购商品类型
     */
    private List<Integer> purchaseSpuTypeList;

    /**
     * 按首笔核销商品ID
     */
    private List<Long> firstVerificationDemandGoodsIdList;

    /**
     * 分页大小
     */
    private Integer pageSize;

    /**
     * 按采购商品ID
     */
    private List<Long> purchaseDemandGoodsIdList;
}
