package cn.com.duiba.quanyi.center.api.remoteservice.refund;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.refund.RefundChangeRecordDto;
import cn.com.duiba.quanyi.center.api.param.refund.RefundChangeRecordPageQueryParam;

/**
 * 退款变更记录远程服务接口
 *
 * @author yangyukang
 * @date 2025/1/21
 */
@AdvancedFeignClient
public interface RemoteRefundChangeRecordService {

    /**
     * 分页查询退款变更记录
     *
     * @param param 查询参数
     * @return 分页结果
     */
    List<RefundChangeRecordDto> selectPage(RefundChangeRecordPageQueryParam param);

    /**
     * 根据条件查询总记录数
     *
     * @param param 查询参数
     * @return 总记录数
     */
    long selectCount(RefundChangeRecordPageQueryParam param);

    /**
     * 根据ID查询退款变更记录
     *
     * @param id 主键ID
     * @return 退款变更记录
     */
    RefundChangeRecordDto selectById(Long id);

    /**
     * 插入退款变更记录
     *
     * @param dto 退款变更记录DTO
     * @return 影响行数
     */
    int insert(RefundChangeRecordDto dto);

    /**
     * 更新退款变更记录
     *
     * @param dto 退款变更记录DTO
     * @return 影响行数
     */
    int update(RefundChangeRecordDto dto);

}
