package cn.com.duiba.quanyi.center.api.remoteservice.insurance.land;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.land.InsuranceLandAuthInfoDto;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceLandAuthInfoSearchParam;

import java.util.List;

/**
 * 大地保险用户认证信息表
 * @author kjj mybatis generator 
 * @date 2024-06-27
 */
@AdvancedFeignClient
public interface RemoteInsuranceLandAuthInfoService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 大地保险用户认证信息集合
     */
    List<InsuranceLandAuthInfoDto> selectPage(InsuranceLandAuthInfoSearchParam param);

    /**
     * 根据代码和用户名查询
     * @param param 查询条件
     * @return 大地保险用户认证信息集合
     */
    InsuranceLandAuthInfoDto selectByCodeAndName(InsuranceLandAuthInfoSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InsuranceLandAuthInfoSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 大地保险用户认证信息
     */
    InsuranceLandAuthInfoDto selectById(Long id);

    /**
     * 新增
     * @param dto 大地保险用户认证信息
     * @return 执行结果
     */
    int insert(InsuranceLandAuthInfoDto dto);

    /**
     * 更新
     * @param dto 大地保险用户认证信息
     * @return 影响行数
     */
    int update(InsuranceLandAuthInfoDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据条件查询
     * @param param 查询条件
     * @return 大地保险用户认证信息集合
     */
    List<InsuranceLandAuthInfoDto> selectByCondition(InsuranceLandAuthInfoSearchParam param);

}