package cn.com.duiba.quanyi.center.api.remoteservice.dbgroup;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.dbgroupgoodsread.SupplierOrderWxCouponCallbackDto;

import java.util.List;

/**
 * 微信立减金回调记录服务
 * 
 * @author cxw
 * @date 2025-10-30 15:30
 */
@AdvancedFeignClient
public interface RemoteSupplierOrderWxCouponCallbackService {

    /**
     * 根据微信券ID和批次号查询回调记录
     *
     * @param wxCouponId 微信返回的券ID
     * @param stockId 微信批次号
     * @return 回调记录集合
     */
    List<SupplierOrderWxCouponCallbackDto> selectByWxCouponIdAndStockId(String wxCouponId, String stockId);
}

