package cn.com.duiba.quanyi.goods.service.api.dto.goodSpu;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * SPU表
 *
 * @author kjj mybatis generator
 * @date 2023-11-21
 */
@Data
public class GoodSpuDto implements Serializable {

    private static final long serialVersionUID = 17005481379029427L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 供应商id
     */
    private Long supplierId;

    /**
     * 商品编码
     */
    private String spuCode;

    /**
     * 商品名称
     */
    private String spuName;

    /**
     * 商品类型，1-实物，2-微信立减金
     */
    private Integer spuType;

    /**
     * 商品主图链接，多张图用英文 逗号 分割
     */
    private String mainImgs;

    /**
     * 商品详情图链接，多张图用英文 逗号 分割
     */
    private String detailImgs;

    /**
     * 商品描述
     */
    private String spuDesc;

    /**
     * 最低供货价，单位分，比如1元，数据存为100
     */
    private Integer minSupplyPrice;

    /**
     * 最高供货价，单位分，比如1元，数据存为100
     */
    private Integer maxSupplyPrice;

    /**
     * 最低指导价，单位分，比如1元，数据存为100
     */
    private Integer minMarketPrice;

    /**
     * 最高指导价，单位分，比如1元，数据存为100
     */
    private Integer maxMarketPrice;

    /**
     * 最低建议售价，单位分，比如1元，数据存为100
     */
    private Integer minSellPrice;

    /**
     * 最高建议售价，单位分，比如1元，数据存为100
     */
    private Integer maxSellPrice;

    /**
     * 商品状态：0-停用，1-启用
     */
    private Integer spuStatus;

    /**
     * 商品备注
     */
    private String spuRemark;

    /**
     * 创建人ID
     */
    private Long createOperatorId;

    /**
     * 创建人姓名
     */
    private String createOperatorName;

    /**
     * 是否已删除：0-未删除，1-已删除
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * spu扩展字段，json格式
     */
    private String extJson;
}