package cn.com.duiba.quanyi.goods.service.api.param.cardSecret;

import cn.com.duiba.quanyi.goods.service.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class CardSecretQueryParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = 3491253223016071364L;

    /**
     * 卡密商品ID
     */
    private Long spuId;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 生效时间
     */
    private Date effectiveTime;

    /**
     * 失效时间
     */
    private Date expirationTime;

    /**
     * 创建时间-开始
     */
    private Date createTimeStart;

    /**
     * 创建时间-结束
     */
    private Date createTimeEnd;

    /**
     * 创建人操作Id
     */
    private Long createOperatorId;

    /**
     * 状态 0-启用 1-未启用
     */
    private Integer status;

}
