package cn.com.duiba.quanyi.goods.service.api.param.cardSecretActivity;

import cn.com.duiba.quanyi.goods.service.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 卡密批次活动关联表
 *
 * @author kjj mybatis generator
 * @date 2023-11-21
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class CardSecretActivitySearchParam extends PageQuery {

    private static final long serialVersionUID = 1700548053279897L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 卡密批次主键,tb_card_secret.id
     */
    private Long cardSecretId;

    /**
     * 活动主键, tb_activity.id
     */
    private Long activityId;

    /**
     * 活动奖品主键, tb_activity_prize.id
     */
    private Long activityPrizeId;

    /**
     * 活动类型：1=白名单领奖、2=兑吧卡密包
     */
    private Integer activityType;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}