package cn.com.duiba.quanyi.goods.service.api.remoteservice.cardSecret;

import cn.com.duiba.quanyi.goods.service.api.dto.cardSecret.CardSecretDto;
import cn.com.duiba.quanyi.goods.service.api.param.cardSecret.CardSecretQueryParam;

import java.util.List;

/**
 * CardSecretRemoteService
 */
public interface CardSecretRemoteService {

    /**
     * 更新
     *
     * @param dto 参数dto
     * @return 影响行数
     */
    Long update(CardSecretDto dto);

    /**
     * 保存
     *
     * @param dto 参数dto
     * @return 影响行数
     */
    Long insert(CardSecretDto dto);

    /**
     * 根据主键ID查询
     *
     * @param id 主键ID
     * @return CardSecretDto
     */
    CardSecretDto selectById(Long id);

    /**
     * 删除
     *
     * @param id 主键ID
     * @return 影响行数
     */
    int delete(Long id);

    /**
     * 统计行数
     *
     * @param queryParam 查询参数
     * @return 行数
     */
    Integer count(CardSecretQueryParam queryParam);

    /**
     * 分页查询
     *
     * @param queryParam 查询参数
     * @return A List Of CardSecretDto
     */
    List<CardSecretDto> selectPage(CardSecretQueryParam queryParam);

}
