package cn.com.duiba.quanyi.goods.service.api.remoteservice.goodSpu;

import cn.com.duiba.quanyi.goods.service.api.dto.goodSpu.GoodSpuDto;
import cn.com.duiba.quanyi.goods.service.api.param.goodSpu.GoodSpuQueryParam;

import java.util.List;

/**
 * RemoteGoodSpuService.
 */
public interface RemoteGoodSpuService {

    /**
     * 统计行数
     *
     * @param queryParam 查询参数
     * @return 行数
     */
    Integer count(GoodSpuQueryParam queryParam);

    /**
     * 分页查询
     *
     * @param queryParam 查询行数
     * @return 结果
     */
    List<GoodSpuDto> selectPage(GoodSpuQueryParam queryParam);

    /**
     * 根据id查询
     *
     * @param id id
     * @return GoodSpuDto
     */
    GoodSpuDto findById(Long id);

    /**
     * 新增
     *
     * @param dto dto
     * @return id
     */
    Long insert(GoodSpuDto dto);

    /**
     * 更新
     *
     * @param demandDto dto
     * @return id
     */
    int update(GoodSpuDto dto);

    /**
     * 更新状态
     *
     * @param id     id
     * @param status 状态
     * @return 影响行数
     */
    int updateStatus(Long id, int status);

    /**
     * 逻辑删除
     *
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

}
