package cn.com.duiba.quanyi.goods.service.api.enums.supplier;

import cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 虚拟商品供应商code枚举
 * 2023/2/9 .
 *
 * @author guoyanfei
 */
@Getter
@AllArgsConstructor
public enum SupplierApiCodeEnum {
    WX_FAVOR_ZY("wx_favor_zy", "微信立减金", SpuTypeEnum.WX_COUPON, true),
    ALIPAY_COUPON_CARD("alipay_coupon_card", "支付宝立减金", SpuTypeEnum.ALIPAY_COUPON, true),
    I_QI_YI_ZC("i_qi_yi_zc", "爱奇艺直充", SpuTypeEnum.I_QI_YI_ZC, true),
    ALIPAY_COUNT_COINS("alipay_count_coins", "支付宝数币红包", SpuTypeEnum.ALIPAY_COUNT_COINS, true),
    CCB_PAY_COUNT_COINS("ccb_count_coins", "建行数币红包", SpuTypeEnum.CCB_COUNT_COINS, true),
    CARD_SECRET("card_secret", "卡密", SpuTypeEnum.KA_MI, true),
    MEI_TUAN_STORE_Y_S_S_H_ZC("y_s_s_h_mei_tuan_store", "美团到店-银盛数惠-直冲", SpuTypeEnum.MEI_TUAN_STORE, true),
    YOU_KU_YI_AN("youku_yian", "易安优酷", SpuTypeEnum.YOU_KU, true),
    TE_LAI_DIAN_COUPON_ZC("te_lai_dian_coupon", "特来电卡券直充", SpuTypeEnum.TE_LAI_DIAN_COUPON, true),
    ;

    private final String code;
    private final String desc;
    private final SpuTypeEnum spuType;
    private final boolean canSelect;

    private static final Map<String, SupplierApiCodeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(SupplierApiCodeEnum::getCode, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     *
     * @param code 枚举值
     * @return 枚举
     */
    public static SupplierApiCodeEnum getByCode(String code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
}
