package cn.com.duiba.quanyi.goods.service.api.remoteservice.order.processor.virtual;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.BaseOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.telaidian.TeLaiDianCouponZcOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.telaidian.TeLaiDianCouponZcOrderRetryReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.BaseResult;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.OrderCreateResult;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.virtual.telaidian.TeLaiDianCouponZcOrderResult;

/**
 * RemoteOrderProcessorTeLaiDianCouponZcService
 *
 * @author fmk
 */
@AdvancedFeignClient
public interface RemoteOrderProcessorTeLaiDianCouponZcService {

    /**
     * 下单
     *
     * @param req 下单所需参数
     * @return 下单结果
     */
    OrderCreateResult create(BaseOrderCreateReq<TeLaiDianCouponZcOrderCreateReq> req);

    /**
     * 异步重试
     *
     * @param req 重试参数
     * @return 提交结果
     */
    BaseResult asyncRetry(TeLaiDianCouponZcOrderRetryReq req);

    /**
     * 查询订单结果
     *
     * @param customerOrderNo 客户订单号
     * @return 订单结果
     */
    TeLaiDianCouponZcOrderResult findOrderResult(String customerOrderNo);

}
