/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.goods.service.api.enums.supplier;

import cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum SupplierApiCodeEnum {
    WX_FAVOR_ZY("wx_favor_zy", "\u5fae\u4fe1\u7acb\u51cf\u91d1", SpuTypeEnum.WX_COUPON, true),
    ALIPAY_COUPON_CARD("alipay_coupon_card", "\u652f\u4ed8\u5b9d\u7acb\u51cf\u91d1", SpuTypeEnum.ALIPAY_COUPON, true),
    I_QI_YI_ZC("i_qi_yi_zc", "\u7231\u5947\u827a\u76f4\u5145", SpuTypeEnum.I_QI_YI_ZC, true),
    ALIPAY_COUNT_COINS("alipay_count_coins", "\u652f\u4ed8\u5b9d\u6570\u5e01\u7ea2\u5305", SpuTypeEnum.ALIPAY_COUNT_COINS, true),
    CCB_PAY_COUNT_COINS("ccb_count_coins", "\u5efa\u884c\u6570\u5e01\u7ea2\u5305", SpuTypeEnum.CCB_COUNT_COINS, true),
    CARD_SECRET("card_secret", "\u5361\u5bc6", SpuTypeEnum.KA_MI, true),
    MEI_TUAN_STORE_Y_S_S_H_ZC("y_s_s_h_mei_tuan_store", "\u7f8e\u56e2\u5230\u5e97-\u94f6\u76db\u6570\u60e0-\u76f4\u51b2", SpuTypeEnum.MEI_TUAN_STORE, true),
    YOU_KU_YI_AN("youku_yian", "\u6613\u5b89\u4f18\u9177", SpuTypeEnum.YOU_KU, true),
    TE_LAI_DIAN_COUPON_ZC("te_lai_dian_coupon", "\u7279\u6765\u7535\u5361\u5238\u76f4\u5145", SpuTypeEnum.TE_LAI_DIAN_COUPON, true),
    TUAN_YOU_YI_AN("tuan_you_yi_an", "\u56e2\u6cb9\u6613\u5b89", SpuTypeEnum.TUAN_YOU, true),
    WX_TRANSFER_JI_GAO("wx_transfer_ji_gao", "\u5fae\u4fe1\u5230\u96f6\u94b1-\u7ee7\u768b", SpuTypeEnum.WX_TRANSFER, true),
    WX_TRANSFER_KA_CHI("wx_transfer_ka_chi", "\u5fae\u4fe1\u5230\u96f6\u94b1-\u5361\u6c60", SpuTypeEnum.WX_TRANSFER, true);

    private final String code;
    private final String desc;
    private final SpuTypeEnum spuType;
    private final boolean canSelect;
    private static final Map<String, SupplierApiCodeEnum> ENUM_MAP;

    public static SupplierApiCodeEnum getByCode(String code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public SpuTypeEnum getSpuType() {
        return this.spuType;
    }

    public boolean isCanSelect() {
        return this.canSelect;
    }

    private SupplierApiCodeEnum(String code, String desc, SpuTypeEnum spuType, boolean canSelect) {
        this.code = code;
        this.desc = desc;
        this.spuType = spuType;
        this.canSelect = canSelect;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(SupplierApiCodeEnum.values()).collect(Collectors.toMap(SupplierApiCodeEnum::getCode, Function.identity(), (v1, v2) -> v2)));
    }
}

