package cn.com.duiba.quanyi.goods.service.api.remoteservice.order.processor.virtual;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.BaseOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.OrderConfirmReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.tuanyou.TuanYouOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.BaseResult;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.OrderCreateResult;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.virtual.tuanyou.TuanYouOrderResult;

/**
 * 订单-易安团油
 */
@AdvancedFeignClient
public interface RemoteOrderProcessorTuanYouService {

    /**
     * 下单
     *
     * @param dto 下单所需参数
     * @return 下单结果
     */
    OrderCreateResult create(BaseOrderCreateReq<TuanYouOrderCreateReq> dto);

    /**
     * 确认订单（订单状态 已下单 -> 待发货）
     * 使用建议：
     * 场景1：在客户业务中，订单需要审核，审核通过才可以发货，此时【确认订单】操作可以认为订单审核操作
     *
     * @param dto 请求参数
     * @return 确认结果
     */
    BaseResult confirm(OrderConfirmReq dto);

    /**
     * 查询订单结果
     *
     * @param customerOrderNo 客户订单号
     * @return 订单结果
     */
    TuanYouOrderResult findOrderResult(String customerOrderNo);
}
