package cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.ccb;

import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.BaseOrderCreateExtReq;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author yangyukang
 * @date 2023/8/9 10:14
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class CcbCountCoinsOrderCreateReq extends BaseOrderCreateExtReq {

    private static final long serialVersionUID = 6077713184294709356L;
    
    /**
     * 活动编号id
     * 需向省行相关部门索取
     * 必填，最大长度50
     */
    private String ccbActId;

    /**
     * 手机号
     * 必选，最大长度64
     */
    private String phone;

    /**
     * 不可大于活动最大金额
     */
    private Long amount;

    /**
     * 活动密钥
     * 需向省行相关部门索取
     */
    private String ccbAppKey;
}
