package cn.com.duiba.quanyi.goods.service.api.dto.order.supplier;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 供应商订单表
 * @author kjj mybatis generator 
 * @date 2023-11-28
 */
@Data
public class SupplierOrderDto implements Serializable {
     
    private static final long serialVersionUID = 17011695582065057L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 唯一订单号
     */
    private String orderNo;

    /**
     * 供应商返回的唯一流水号
     */
    private String supplierBizNo;

    /**
     * 状态
     */
    private Integer orderStatus;

    /**
     * 供应商id，冗余
     */
    private Long supplierId;

    /**
     * spuId，冗余
     */
    private Long spuId;

    /**
     * skuId，冗余
     */
    private Long skuId;

    /**
     * 调用供应商的结果快照，存放json，默认为null
     */
    private String invokeHistory;

    /**
     * 供应商api标识码
     */
    private String supplierApiCode;

    /**
     * 供应商错误信息
     */
    private String errMsg;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}