package cn.com.duiba.quanyi.goods.service.api.param.order;

import cn.com.duiba.quanyi.goods.service.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;

/**
 * 订单表
 * @author kjj mybatis generator 
 * @date 2023-11-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class OrderSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17011668851615752L;

    /**
     * 唯一订单号
     */
    private String orderNo;

    /**
     * SPU id
     */
    private Long spuId;

    /**
     * SKU id
     */
    private Long skuId;

    /**
     * 供应商id
     */
    private Long supplierId;

    /**
     * 客户id
     */
    private Long customerId;

    /**
     * 客户订单号
     */
    private String customerOrderNo;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 商品类型
     */
    private Integer spuType;
}