package cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.alipay;

import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.BaseOrderCreateExtReq;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 支付宝立减金发放
 * @author lizhi
 * @date 2023/4/17 1:36 PM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class AlipayCouponOrderCreateReq extends BaseOrderCreateExtReq {
    
    private static final long serialVersionUID = -4429821352256408204L;

    /**
     * 支付宝用户ID
     * user_id，logon_id，phone_id不能同时为空，优先级依次降低。
     * 注：UID为用户唯一标识，可通过授权方式获取，具体见产品文档。
     * 特殊可选，最大长度16
     */
    private String userId;

    /**
     * 支付宝用户ID 
     * user_id，logon_id，phone_id不能同时为空，优先级依次降低。
     * 注：若手机号为非用户注册支付宝账号，则会发放失败。
     * 特殊可选，最大长度128
     */
    private String loginId;

    /**
     * 该参数将先匹配用户手机号对应支付宝账号，若存在且完成实名认证则以此支付宝账号发放，若该支付宝账号未完成实名认证则发放失败；若用户手机号对应支付宝账号不存在，则再匹配用户手机号绑定支付宝账号。
     * 若用户手机号绑定多个支付宝账号，则以系统判定的常用支付宝账号为准。请优先使用user_id和logon_id。
     * 特殊可选，最大长度11
     */
    private String phoneId;

    /**
     * 数字分行活动id
     * 必选，最大长度32
     */
    private String actId;

    /**
     * 支付宝分配给开发者的应用ID
     * 必选，最大长度32
     */
    private String appId;
}
