package cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result;

import cn.com.duiba.quanyi.goods.service.api.enums.order.OrderErrorCodeEnum;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2023/8/9 11:29
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
public class BaseResult implements Serializable {
    
    private static final long serialVersionUID = 5584482360928370500L;

    /**
     * 响应码
     */
    private String code;

    /**
     * 错误信息，请求失败时有值
     */
    private String errMsg;

    /**
     * 是否成功
     * @return 是否成功
     */
    public boolean isSuccess() {
        return OrderErrorCodeEnum.GC000000.name().equals(code);
    }
    
    public <T extends BaseResult> T buildError(String code, String errMsg) {
        this.code = code;
        this.errMsg = errMsg;
        return (T)this;
    }
}
