package cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.virtual.alipay;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;

/**
 * 支付宝数币详情
 * @author yangyukang
 * @date 2023/10/19
 */
@ToString(callSuper = true)
@Data
public class AlipayCountCoinsPrizeCustomDisplayInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 奖品权益类型 "VOUCHER", "券" "MEMBER_CARD", "会员卡" "SALE_GIFT_PACKAGE", "券包" "SKIN", "皮肤"
     * 枚举值
     * 券: VOUCHER
     * 会员卡: MEMBER_CARD
     * 券包: SALE_GIFT_PACKAGE
     * 皮肤: SKIN
     */
    private String formType;

    /**
     * 奖品权益子类型
     * 枚举值
     * 红包: RED_PACKET
     * 代金券: CASH_COUPON
     * 兑换券: EXCHANGE_COUPON
     * 折扣券: DISCOUNT_COUPON
     * 特价券: SPECIAL_OFFER_COUPON
     * 商品券: COMMODITY_COUPON
     * 通用: OTHER_PRIZE
     * 自定义券: CUSTOMER_DEFINE_COUPON
     */
    private String subFormType;

    /**
     * 奖品权益单品优惠类型
     * 枚举值
     * 小程序商品券: APP_ITEM
     * 其他: OTHER
     */
    private String prizeItemType;

    /**
     * "PLATFORM","平台", "ISV", "ISV", "MERCHANT", "商户", "PLAN", "新方案", "PROMOORDER", "权益平台", "AUTO", "自动"
     * 枚举值
     * 平台: PLATFORM
     * ISV: ISV
     * 商户: MERCHANT
     * 新方案: PLAN
     * 权益平台: PROMOORDER
     * 自动: AUTO
     */
    private String platformType;

    /**
     * 商家名称
     *
     */
    private String prizeMerchantName;

    /**
     * 品牌Logo图片
     */
    private String prizeLogo;

    /**
     * 奖品图标地址
     */
    private String prizeIcon;

    /**
     * 奖品展示名称（短）
     */
    private String prizeDisplayName;

    /**
     * 奖品展示名称(短,无金额信息)
     */
    private String prizeNameWithoutAmount;

    /**
     * 奖品展示名称（中）
     */
    private String prizeMediumName;

    /**
     * 奖品展示名称（长）
     */
    private String prizeLongName;

    /**
     * 投放链接
     */
    private String promoLink;

    /**
     * 门槛金额，单位分
     */
    private String thresholdMoneyAmount;

    /**
     * 使用门槛文案
     */
    private String thresholdAmountText;

    /**
     * 优惠信息，单位分
     */
    private String preferentialMoneyAmount;

    /**
     * 特价信息，单位分
     */
    private String specifiedMoneyAmount;

    /**
     * 原面额，单位分
     */
    private String originalMoneyAmount;

    /**
     * 上限面额，单位分
     */
    private String ceilMoneyAmount;

    /**
     * 折扣信息
     */
    private String discount;

    /**
     * 面额单位
     */
    private String amountUnitText;

    /**
     * 无特殊需求用 showAmountText + amountUnitText 表达 减几元、打几折、特价金额 即可
     */
    private String showAmountText;

    /**
     * 单品名称
     */
    private String itemName;

    /**
     * 奖品背景图url
     */
    private String prizeBackgroundPicUrl;

    /**
     * 总使用次数
     */
    private String maxUseCount;

    /**
     * 使用范围
     */
    private String scope;

    /**
     * 描述奖品的使用说明，如消费满1000元可用
     */
    private String prizeUsageDesc;

    /**
     * 对奖品的使用规则说明，如使用限制等
     */
    private String prizeRuleDesc;

}
