package cn.com.duiba.quanyi.goods.service.api.remoteservice.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.order.OrderDto;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.OrderGrantResult;
import cn.com.duiba.quanyi.goods.service.api.param.order.OrderSearchParam;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 订单表
 * @author kjj mybatis generator 
 * @date 2023-11-28
 */
@AdvancedFeignClient
public interface RemoteOrderService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 订单集合
     */
    List<OrderDto> selectPage(OrderSearchParam param);

    /**
     * 根据条件,查询记录的总记录数，管理后端列表查询专用
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(OrderSearchParam param);

    /**
     * 查询发放结果
     * 
     * @param customerOrderNos 客户订单号
     * @return 发放结果
     */
    Map<String, OrderGrantResult> batchSelectGrantResult(Set<String> customerOrderNos);

    /**
     * 查询发放结果
     *
     * @param customerOrderNo 客户订单号
     * @return 发放结果
     */
    OrderGrantResult selectGrantResult(String customerOrderNo);
}