package cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.wx;

import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.VirtualBaseOrderRetryReq;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author lizhi
 * @date 2023/8/9 10:14
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class WxCouponOrderRetryReq extends VirtualBaseOrderRetryReq {
    
    private static final long serialVersionUID = 7022897259613176233L;

    /**
     * 批次号		 
     */
    private String stockId;

    /**
     * 商户ID
     */
    private String mchId;

    /**
     * 创建批次的商户号	 
     */
    private String stockCreatorMchId;

    /**
     * 公众账号ID		 
     */
    private String appId;

    /**
     * 收款用户openid
     */
    private String openId;

    /**
     * 指定面额发券，面额
     * 说明：定面额发券场景，券面额，其他场景不需要填，单位：分。 
     * 校验规则：仅在发券时指定面额及门槛的场景才生效，常规发券场景请勿传入该信息。
     * 选填
     */
    private Integer couponValue;

    /**
     * 指定面额发券，券门槛
     * 说明：指定面额发券批次门槛，其他场景不需要，单位：分。 
     * 校验规则：仅在发券时指定面额及门槛的场景才生效，常规发券场景请勿传入该信息。
     * 选填
     */
    private Integer couponMinimum;
}
