package cn.com.duiba.quanyi.goods.service.api.enums.order;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2023/11/30 15:08
 */
@Getter
@AllArgsConstructor
public enum OrderStatusEnum {

    CREATED(0, "已下单"),
    UNSHIPPED(1, "待发货"),
    SHIPPED(2, "待收货"),
    COMPLETED(3, "已完成"),
    CANCELED(4, "已取消");

    private final Integer code;

    private final String desc;
    
    private static final Map<Integer, OrderStatusEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OrderStatusEnum::getCode, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param code 枚举值
     * @return 枚举
     */
    public static OrderStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
    
    public String getLogName() {
        return desc + "[" + code + "]";
    }
}
