package cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2023/12/22 16:42
 */
@Data
public class OrderAccountInfoDto implements Serializable {
    
    private static final long serialVersionUID = -3782070029939201299L;

    /**
     * 微信立减金：指定面额发券，面额
     * 说明：定面额发券场景，券面额，其他场景不需要填，单位：分。 
     */
    private Integer couponValue;

    /**
     * 微信立减金：指定面额发券，券门槛
     * 说明：指定面额发券批次门槛，其他场景不需要，单位：分。 
     */
    private Integer couponMinimum;

    /**
     * 微信立减金/到零钱/现金红包：微信用户openId
     */
    private String wxOpenId;

    /**
     * 微信立减金/到零钱/现金红包：微信公众号、小程序AppID
     */
    private String wxAppId;

    /**
     * 微信立减金：批次号
     */
    private String wxStockId;

    /**
     * 支付宝立减金/数币：支付宝用户id，可通过支付宝授权方式获取
     */
    private String alipayUserId;

    /**
     * 支付宝立减金/数币：支付宝openId, 映射支付宝user_id
     * 请使用open_id，后续user_id将不支持新接入使用，存量已对接的也将逐步回收。
     */
    private String alipayOpenId;

    /**
     * 支付宝立减金/数币：支付宝登录账号，邮箱格式
     */
    private String alipayLoginId;

    /**
     * 支付宝立减金/数币：支付宝登录账号，手机号格式
     */
    private String alipayPhoneId;

    /**
     * 支付宝立减金/数币：活动id
     */
    private String alipayActId;

    /**
     * 支付宝立减金/数币：支付宝分配给开发者的应用ID
     */
    private String alipayAppId;

    /**
     * 充值手机号
     */
    private String phone;

    /**
     * 充值qq号
     */
    private String qqAccount;


    /**
     * 收货人姓名
     */
    private String name;

    /**
     * 收货地址 省份
     */
    private String province;

    /**
     * 收货地址 市
     */
    private String city;

    /**
     * 收货地址 区、县
     */
    private String district;

    /**
     * 收货地址 街道
     */
    private String street;

    /**
     * 收货详细地址
     */
    private String address;

    /**
     * 获取账号信息
     * @return 账号信息
     */
    public String getAccountInfo() {
        StringBuilder sb = new StringBuilder();
        if (couponValue != null) {
            sb.append("微信立减金发放面额：").append(couponValue).append("\n");
        }
        if (couponMinimum != null) {
            sb.append("微信立减金使用门槛：").append(couponValue).append("\n");
        }
        if (StringUtils.isNotBlank(wxOpenId)) {
            sb.append("微信openId：").append(wxOpenId).append("\n");
        }
        if (StringUtils.isNotBlank(wxAppId)) {
            sb.append("微信appId：").append(wxAppId).append("\n");
        }
        if (StringUtils.isNotBlank(wxStockId)) {
            sb.append("微信立减金批次号：").append(wxStockId).append("\n");
        }
        if (StringUtils.isNotBlank(alipayUserId)) {
            sb.append("支付宝userId：").append(alipayUserId).append("\n");
        }
        if (StringUtils.isNotBlank(alipayOpenId)) {
            sb.append("支付宝openId：").append(alipayOpenId).append("\n");
        }
        if (StringUtils.isNotBlank(alipayLoginId)) {
            sb.append("支付宝账号：").append(alipayLoginId).append("\n");
        }
        if (StringUtils.isNotBlank(alipayPhoneId)) {
            sb.append("支付宝手机号：").append(alipayPhoneId).append("\n");
        }
        if (StringUtils.isNotBlank(alipayActId)) {
            sb.append("支付宝活动ID：").append(alipayActId).append("\n");
        }
        if (StringUtils.isNotBlank(alipayAppId)) {
            sb.append("支付宝应用ID：").append(alipayAppId).append("\n");
        }
        if (StringUtils.isNotBlank(phone)) {
            sb.append("手机号：").append(phone).append("\n");
        }
        if (StringUtils.isNotBlank(qqAccount)) {
            sb.append("qq号：").append(qqAccount).append("\n");
        }
        if (StringUtils.isNotBlank(name)) {
            sb.append("姓名：").append(name).append("\n");
        }
        if (!StringUtils.isAllBlank(province, city, district, street, address)) {
            sb.append("地址：").append(getAddress()).append("\n");
        }
        return sb.substring(0, sb.length() - 1);
    }
    
    private String getAddress() {
        String add = "";
        if (StringUtils.isNotBlank(province)) {
            add = add + province;
        }
        if (StringUtils.isNotBlank(city)) {
            add = add + city;
        }
        if (StringUtils.isNotBlank(district)) {
            add = add + district;
        }
        if (StringUtils.isNotBlank(street)) {
            add = add + street;
        }
        if (StringUtils.isNotBlank(address)) {
            add = add + address;
        }
        return add;
    }
}
