package cn.com.duiba.quanyi.goods.service.api.remoteservice.order.processor.object;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.BaseOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.object.ObjectOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.object.ObjectOrderShipReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.BaseResult;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.OrderCreateResult;

/**
 * RemoteOrderProcessorQQVipService
 *
 * @author fmk
 */
@AdvancedFeignClient
public interface RemoteOrderProcessorObjectService {

    /**
     * 下单
     *
     * @param req 下单所需参数
     * @return 下单结果
     */
    OrderCreateResult create(BaseOrderCreateReq<ObjectOrderCreateReq> req);

    /**
     * 发货
     * 
     * @param orderNo 订单号
     * @param supplierId 供应商ID
     * @param shipperInfo 发货人信息
     * @param req 发货所需参数
     * @return 发货结果
     */
    BaseResult ship(String orderNo, Long supplierId, String shipperInfo, ObjectOrderShipReq req);

    /**
     * 签收
     * 
     * @param orderNo 订单号
     * @param remark 备注
     * @return 签收结果
     */
    BaseResult complete(String orderNo, String remark);

    /**
     * 取消订单（待发货状态取消发货）
     * 
     * @param orderNo 订单号
     * @param supplierId 供应商ID
     * @param remark 备注
     * @return 取消结果
     */
    BaseResult cancel(String orderNo, Long supplierId, String remark);

}
