package cn.com.duiba.quanyi.goods.service.api.remoteservice.supplier;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.supplier.SupplierAccountDto;
import cn.com.duiba.quanyi.goods.service.api.param.supplier.SupplierAccountSearchParam;
import java.util.List;

/**
 * 供应商账户表
 * @author kjj mybatis generator 
 * @date 2024-03-22
 */
@AdvancedFeignClient
public interface RemoteSupplierAccountService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 供应商账户集合
     */
    List<SupplierAccountDto> selectPage(SupplierAccountSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(SupplierAccountSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 供应商账户
     */
    SupplierAccountDto selectById(Long id);

    /**
     * 根据唯一键查询(包含已删除的)
     * @param supplierId 供应商ID
     * @param accountNo 账号
     * @return 供应商账户
     */
    SupplierAccountDto selectByUk(Long supplierId, String accountNo);

    /**
     * 根据账号查询(不包含已删除的)
     * @param accountNo 账号
     * @return 供应商账户
     */
    List<SupplierAccountDto> selectByAccountNo(String accountNo);

    /**
     * 新增
     * @param dto 供应商账户
     * @return 影响行数
     */
    int insert(SupplierAccountDto dto);

    /**
     * 软删
     * @param id 主键
     * @param delOperatorId 删除人ID
     * @param delOperatorName 删除人姓名
     * @return 影响行数
     */
    int delete(Long id, Long delOperatorId, String delOperatorName);
}