package cn.com.duiba.quanyi.goods.service.api.dto.order;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 订单状态变更记录表
 *
 * @author kjj mybatis generator
 * @date 2023-11-28
 */
@Data
public class OrderStatusChangedRecordDto implements Serializable {

    private static final long serialVersionUID = 17011688085244100L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 唯一订单号
     */
    private String orderNo;

    /**
     * 变更前订单状态
     * @see cn.com.duiba.quanyi.goods.service.api.enums.order.supplier.SupplierOrderStatusEnum
     */
    private Integer preOrderStatus;

    /**
     * 变更后订单状态
     * @see cn.com.duiba.quanyi.goods.service.api.enums.order.supplier.SupplierOrderStatusEnum
     */
    private Integer postOrderStatus;

    /**
     * 备注（如：取消原因）
     */
    private String remark;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}