package cn.com.duiba.quanyi.goods.service.api.param.cardsecret;

import cn.com.duiba.quanyi.goods.service.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;

/**
 * CardSecretCouponQueryParam
 * @author fumingkun
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class CardSecretCouponQueryParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = 3491253223016071364L;

    /**
     * 批次ID
     */
    private Long cardSecretBatchId;

    /**
     * 劵码
     */
    private String couponCode;

    /**
     * 链接劵
     */
    private String linkCode;

    /**
     * spuId
     */
    private Long spuId;

    /**
     * 账号
     */
    private String accountNo;

    /**
     * 发放状态 0-未发放 1-已发放
     * @see cn.com.duiba.quanyi.goods.service.api.enums.BooleanEnum
     */
    private Integer couponStatus;

}
