package cn.com.duiba.quanyi.goods.service.api.remoteservice.cardsecret;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.cardsecret.CardSecretBatchActivityDto;

import java.util.List;
import java.util.Set;

/**
 * RemoteCardSecretActivityService
 * @author fumingkun
 */
@AdvancedFeignClient
public interface RemoteCardSecretBatchActivityService {

    /**
     * 根据卡密批次ID查询
     *
     * @param cardSecretId 卡密批次ID
     * @return A List Of CardSecretActivityDto
     */
    List<CardSecretBatchActivityDto> selectByCardSecretId(Set<Long> cardSecretId);

    /**
     * 根据活动奖项ID和活动类型查询
     *
     * @param activityPrizeId 活动奖项ID
     * @param activityType    活动类型
     * @return A List Of CardSecretActivityDto
     */
    List<CardSecretBatchActivityDto> selectByActivityPrizeId(Long activityPrizeId, Integer activityType);

    /**
     * 批量删除
     *
     * @param ids ids
     */
    void batchDelete(List<Long> ids);

    /**
     * 批量新增
     *
     * @param list 卡密批次号活动关联
     * @return 影响行数
     */
    int batchInsert(List<CardSecretBatchActivityDto> list);

    /**
     * 根据活动批量删除
     * @param activityType 活动类型
     * @param activityPrizeIds 活动奖品ID列表
     * @return 执行结果
     */
    int batchDeleteByActivity(Integer activityType, List<Long> activityPrizeIds);

}
