package cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.wx;

import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.BaseOrderCreateExtReq;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 微信红包参数
 *
 * @author wangguanhua
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class WxRedPacketCreateReq extends BaseOrderCreateExtReq {

    private static final long serialVersionUID = -4579056338049266054L;

    /**
     * 微信公众账号ID
     * 必填
     */
    private String appId;

    /**
     * 用户微信openId
     * 最大32位
     * 必填
     */
    private String openId;

    /**
     * 红包金额，单位：分
     * 必填
     */
    private Long amount;

    /**
     * 微信的红包备注
     * 必填
     */
    private String remark;

    /**
     * 商户名称
     * ● 商品为微信红包时，必填
     */
    private String redpackBusiness;

    /**
     * 红包祝福语
     * ● 商品为微信红包时，必填
     */
    private String redpackBlessings;
}
