package cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.virtual.alipay;

import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.virtual.VirtualBaseOrderResult;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 支付宝数币红包发放响应结果
 *
 * @author yangyukang
 * @date 2023/10/19
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class AlipayCountCoinsOrderResult extends VirtualBaseOrderResult {

    private static final long serialVersionUID = -341414504342211997L;

    /**
     * 是否中奖结果状态，如果为true时返回的结果中的其他字段非空，否则返回的其他字段为空
     * 必选，最大长度5
     */
    private String triggerResult;

    /**
     * 奖品id
     */
    private String prizeId;

    /**
     * 奖品名称
     */
    private String prizeName;

    /**
     * 活动流水id
     */
    private String campLogId;

    /**
     * 发奖流水
     */
    private String prizeLogId;

    /**
     * 活动id
     */
    private String actId;

    /**
     * 奖品唯一标识
     */
    private String prizeFlag;

    /**
     * 拓展字段, 常用key有: prize_amount(奖品金额,单位为元); prize_type(奖品类型);
     * mobile_send_flag(拉新活动发放凭证标识，标识为true且接口返回错误码CERTIFICATE_SEND_SUCCESS时，表示新用户发凭证成功，引导用户使用该手机号注册支付宝账号);
     * errorMsg(错误信息描述); errorMsgType(错误信息类型，包括：CAMP_NOT_VALID--活动未生效，FREQ_OR_COUNT_LIMIT--频率或次数超限，
     * RULE_NOT_PASS--规则未通过，NOT_WIN--未中奖);
     * ruleErrorCode(规则验证不通过的错误码，值为AE0111709606 且返回的errorMsg为“00005000-规则中心规则不通过”时，表示用户已领取过奖品)
     */
    private String extendField;

    /**
     * logonId的脱敏显示
     */
    private String displayName;

    /**
     * 是否幂等，如果为true，代表此次请求幂等，返回的结果为幂等结果。如果为false,代表此次请求是新请求，返回结果为此次触发结果
     */
    private String repeatTriggerFlag;

    /**
     * 外部奖品id，如果为券，则为券id。如果没有，则为空
     */
    private String outPrizeId;

    /**
     * 对客信息
     * 注意事项
     */
    private AlipayCountCoinsPrizeCustomDisplayInfo prizeCustomDisplayInfo;


}
