package cn.com.duiba.quanyi.goods.service.api.remoteservice.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.order.OrderStatusChangedRecordDto;

import java.util.List;
import java.util.Set;

/**
 * 订单状态变更记录表
 *
 * @author kjj mybatis generator
 * @date 2023-11-28
 */
@AdvancedFeignClient
public interface RemoteOrderStatusChangedRecordService {

    /**
     * 根据订单号批量查询
     *
     * @param orderNos 订单号
     * @return 订单状态变更记录
     */
    List<OrderStatusChangedRecordDto> selectByOrderNos(Set<String> orderNos);
}
