package cn.com.duiba.quanyi.goods.service.api.dto.bill;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 支付宝立减金核销记录表
 * @author kjj mybatis generator 
 * @date 2023-12-20
 */
@Data
public class AlipayCouponBillDto implements Serializable {
     
    private static final long serialVersionUID = 1703056590459259L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 支付宝立减金主键,tb_alipay_activity.id
     */
    private Long alipayCouponId;

    /**
     * 支付宝活动ID
     */
    private String alipayActId;

    /**
     * 券ID
     */
    private String voucherId;

    /**
     * 核销时间
     */
    private Date useTime;

    /**
     * 核销金额（分）
     */
    private Long useAmount;

    /**
     * 订单金额（分）
     */
    private Long orderAmount;

    /**
     * 实付金额（分）
     */
    private Long payAmount;

    /**
     * 银行流水号
     */
    private String bankNo;

    /**
     * 支付宝交易号
     */
    private String tradeNo;

    /**
     * 模板ID
     */
    private String templateId;

    /**
     * 卡号前六位
     */
    private String cardPrefix;

    /**
     * 商户PID
     */
    private String storePid;

    /**
     * 预充值方式
     */
    private String preChargeType;

    /**
     * 商家名称
     */
    private String storeName;

    /**
     * 门店ID
     */
    private String shopId;

    /**
     * 门店名称
     */
    private String shopName;

    /**
     * 商圈名称
     */
    private String businessAreaName;

    /**
     * 商圈门店名称
     */
    private String businessAreaShopName;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}