package cn.com.duiba.quanyi.goods.service.api.param.supplier;

import cn.com.duiba.quanyi.goods.service.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 供应商订单-微信大额转账扩展字段
 * @author kjj mybatis generator 
 * @date 2024-05-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class SupplierWxMoreTransferSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17152390446934940L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 客户订单号
     */
    private String customerOrderNo;

    /**
     * 公众账号ID
     */
    private String appId;

    /**
     * openId
     */
    private String openId;

    /**
     * 转账金额，单位：分
     */
    private Long amount;

    /**
     * 用户真实姓名
     */
    private String realName;

    /**
     * 用户身份证号
     */
    private String idCard;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 最后一次状态变更的时间
     */
    private Date updateTime;

    /**
     * 子单号
     */
    private String subOrderNo;

    /**
     * 供应商api标识码
     */
    private String supplierApiCode;

    /**
     * SPU id
     */
    private Long spuId;

    /**
     * SKU id
     */
    private Long skuId;

    /**
     * 发放时间
     */
    private Date grantTime;

    /**
     * 虚拟商品发放状态
     */
    private Integer grantStatus;

    /**
     * 供应商返回的唯一流水号
     */
    private String supplierBizNo;

    /**
     * 供应商错误信息
     */
    private String errMsg;
}