package cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2024/5/20 19:49
 */
@Data
public class CloseResult implements Serializable {
    
    private static final long serialVersionUID = 175537698357903685L;

    /**
     * 是否提交关闭成功
     */
    private boolean success;

    /**
     * 错误码
     */
    private String errorCode;

    /**
     * 错误信息，请求失败时有值
     */
    private String errorMsg;

    public static CloseResult buildErr(String errCode, String errMsg) {
        CloseResult resp = new CloseResult();
        resp.setSuccess(false);
        resp.setErrorCode(errCode);
        resp.setErrorMsg(errMsg);
        return resp;
    }

    public static CloseResult buildSuccess() {
        CloseResult resp = new CloseResult();
        resp.setSuccess(true);
        return resp;
    }
}
