package cn.com.duiba.quanyi.goods.service.api.dto.supplier;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 支付宝立减金回调记录表
 * @author kjj mybatis generator 
 * @date 2023-12-27
 */
@Data
public class SupplierOrderAlipayCouponCallbackDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 客户订单号
     */
    private String customerOrderNo;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 优惠券ID
     */
    private String voucherId;

    /**
     * 活动ID
     */
    private String actId;

    /**
     * 回调类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.coupon.AlipayCouponCallbackEventTypeEnum
     */
    private String eventType;

    /**
     * 支付宝交易号
     */
    private String tradeNo;

    /**
     * 事件对应时间
     */
    private Date eventTime;

    /**
     * 事件对应金额
     */
    private Long eventAmount;

    /**
     * 回调信息json
     */
    private String callbackInfo;
}