package cn.com.duiba.quanyi.goods.service.api.dto.car;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 汽车服务-门店服务编码
 * @author kjj mybatis generator 
 * @date 2024-08-05
 */
@Data
public class CarSerStoreCodeDto implements Serializable {
     
    private static final long serialVersionUID = 17228471405196727L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.goods.service.api.enums.LogicDeleteEnum
     */
    private Integer logicDelete;

    /**
     * 门店id
     */
    private Long storeId;

    /**
     * 平台类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.car.CarSerPlatformTypeEnum
     */
    private Integer platformType;

    /**
     * 门店编码
     */
    private String storeCode;

    /**
     * 兑吧服务编码
     */
    private String dbCode;

    /**
     * 平台服务编码
     */
    private String platformCode;

    /**
     * 服务价格，单位分
     */
    private Long serPrice;

    /**
     * 服务名称
     */
    private String serName;
}