package cn.com.duiba.quanyi.goods.service.api.remoteservice.car;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.car.CarSerStoreDto;

import java.util.List;
import java.util.Map;

/**
 * 汽车服务-门店
 * @author kjj mybatis generator 
 * @date 2024-08-05
 */
@AdvancedFeignClient
public interface RemoteCarSerStoreService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 汽车服务-门店
     */
    CarSerStoreDto selectById(Long id);

    /**
     * 根据主键集合查询
     *
     * @param ids 主键集合
     * @return 汽车服务-门店
     */
    List<CarSerStoreDto> selectByIds(List<Long> ids);

    /**
     * 根据主键集合查询
     *
     * @param ids 主键集合
     * @return 门店id-门店名称
     */
    Map<Long, String> selectStoreNameMapByIds(List<Long> ids);
}