package cn.com.duiba.quanyi.goods.service.api.remoteservice.order.processor.virtual;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.BaseOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.youku.YouKuOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.OrderCreateResult;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.virtual.youku.YouKuOrderResult;

/**
 * 订单-易安优酷
 */
@AdvancedFeignClient
public interface RemoteOrderProcessorYouKuService {

    /**
     * 下单
     *
     * @param dto 下单所需参数
     * @return 下单结果
     */
    OrderCreateResult create(BaseOrderCreateReq<YouKuOrderCreateReq> dto);

    /**
     * 查询订单结果
     *
     * @param customerOrderNo 客户订单号
     * @return 订单结果
     */
    YouKuOrderResult findOrderResult(String customerOrderNo);
}
